package com.app.yourradioapp593.rests;

import com.app.yourradioapp593.callbacks.CallbackAlbumArt;
import com.app.yourradioapp593.callbacks.CallbackCategory;
import com.app.yourradioapp593.callbacks.CallbackCategoryDetail;
import com.app.yourradioapp593.callbacks.CallbackHome;
import com.app.yourradioapp593.callbacks.CallbackRadio;
import com.app.yourradioapp593.callbacks.CallbackSettings;
import com.app.yourradioapp593.callbacks.CallbackSocial;
import com.app.yourradioapp593.models.Value;

import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface ApiInterface {

    String CACHE = "Cache-Control: max-age=0";
    String AGENT = "Data-Agent: Your Radio App";

    @Headers({CACHE, AGENT})
    @GET("api.php?home")
    Call<CallbackHome> getHome(
            @Query("api_key") String api_key
    );

    @Headers({CACHE, AGENT})
    @GET("api.php?radios")
    Call<CallbackRadio> getRadios(
            @Query("count") int count,
            @Query("page") int page,
            @Query("api_key") String api_key
    );

    @Headers({CACHE, AGENT})
    @GET("api.php?categories")
    Call<CallbackCategory> getCategories(
            @Query("api_key") String api_key
    );

    @Headers({CACHE, AGENT})
    @GET("api.php?search")
    Call<CallbackRadio> getSearch(
            @Query("search") String search,
            @Query("count") int count,
            @Query("page") int page,
            @Query("api_key") String api_key
    );

    @Headers({CACHE, AGENT})
    @GET("api.php?search_rtl")
    Call<CallbackRadio> getSearchRtl(
            @Query("search") String search,
            @Query("count") int count,
            @Query("page") int page,
            @Query("api_key") String api_key
    );

    @Headers({CACHE, AGENT})
    @GET("api.php?setting")
    Call<CallbackSettings> getSettings(
            @Query("api_key") String api_key,
            @Query("package_name") String package_name
    );

    @Headers({CACHE, AGENT})
    @GET("api.php?social")
    Call<CallbackSocial> getSocial(
            @Query("api_key") String api_key
    );

    @Headers({CACHE, AGENT})
    @GET("api.php?category_detail")
    Call<CallbackCategoryDetail> getCategoryDetail(
            @Query("id") String id,
            @Query("count") int count,
            @Query("page") int page
    );

    @Headers({CACHE, AGENT})
    @GET("search")
    Call<CallbackAlbumArt> getAlbumArt(
            @Query("term") String term,
            @Query("media") String media,
            @Query("limit") int limit
    );

    @FormUrlEncoded
    @POST("api.php?update_view")
    Call<Value> updateView(
            @Field("id") String id
    );

}
